package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Axis_chassis extends Axis_models
{
	public Axis_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Axis";
		name = getName();
		
		rID_blueprint = cars.cat_01.Axis:0x017Fr;
		defColorIndex = GameLogic.CARCOLOR_GOLD;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;
		
		value = 4000;
		
		fully_stripped_drag = 0.55;
		min_drag = 0.321;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_01.Axis:0x01DEr; //Left taillight dark
		parts_shop_sml[1] = cars.cat_01.Axis:0x01F6r; //Right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_01.Axis:0x00F8r; //Left exhaust
		parts_shop_big[1] = cars.cat_01.Axis:0x00F7r; //Right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.axis:0x000000D0r, "F grill", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000D1r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000D2r, "FL door", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000D3r, "FL seat", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000D5r, "FR door", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000D6r, "FR seat", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000DEr, "L taillights", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000E3r, "R seats", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000E5r, "R windshield", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000E8r, "RL window", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000E9r, "RR window", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000EAr, "trunk", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000F1r, "R headlights", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000F3r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000F6r, "R taillights", actcolor, optical, power );
			addPart( cars.cat_01.axis:0x000000F8r, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000D0r, "F grill", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000D1r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000D2r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000D3r, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000D5r, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000D6r, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000DEr, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000E3r, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000E5r, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000E8r, "RL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000E9r, "RR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000EAr, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000F1r, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000F3r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000F6r, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000F8r, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000CDr, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000DCr, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000DFr, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000F0r, "R sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.axis:0x000000CFr, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.axis:0x000000CEr, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_01.axis:0x000000CDr, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.axis:0x000000DDr, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.axis:0x000000F2r, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_01.axis:0x000000DCr, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.axis:0x000000E4r, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.axis:0x000000EFr, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_01.axis:0x000000F0r, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_01.axis:0x000000E1r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_01.axis:0x000000E0r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_01.axis:0x000000DFr, "R bumper", actcolor, optical, power );
		}

		addPart( cars.cat_01.axis:0x000000EBr, "FR suspension" );
		addPart( cars.cat_01.axis:0x000000ECr, "FL suspension" );
		addPart( cars.cat_01.axis:0x000000EDr, "RR suspension" );
		addPart( cars.cat_01.axis:0x000000EEr, "RL suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );
			addPart( parts.wheels_combo:0x0000001Fr, "wheel" );

		} else
		{
			if ( random() > 0.5 ) //Spider
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
					addPart( parts.wheels_combo:0x00000989r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
					addPart( parts.wheels_combo:0x00000988r, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
					addPart( parts.wheels_combo:0x000000A5r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) //Sparkler
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
					addPart( parts.wheels_combo:0x000000A6r, "wheel" );
				}
			} else //Flat
			{
				if ( (power+optical)*0.5 >= 1.75 )
				{
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 )
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 )
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
				} else
				{
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
					addPart( parts.wheels_combo:0x000000A2r, "wheel" );
				}
			}
		}

		if ( power >= 1.5 )
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.5 )
		{
/*			if ( optical >= 1.5 )
			{
				addPart( parts.running_gear:0x000001BDr, "spring" );
				addPart( parts.running_gear:0x000001BDr, "spring" );
				addPart( parts.running_gear:0x000001BEr, "spring" );
				addPart( parts.running_gear:0x000001BEr, "spring" );
			} else*/
			{
				addPart( parts.running_gear:0x00000209r, "spring" );
				addPart( parts.running_gear:0x00000209r, "spring" );
				addPart( parts.running_gear:0x0000020Ar, "spring" );
				addPart( parts.running_gear:0x0000020Ar, "spring" );
			}
		} else
		{
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000013FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
			addPart( parts.running_gear:0x000014FFr, "spring" );
		}

		if ( power >= 1.3 )
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		} else
		{
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		}

		if ( power >= 1.6 )
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}

		if ( power >= 1.666 ) addPart( parts.engines.I4:0x0000000Br, "2.5L I4 engine", actcolor, optical, (power-1.666)/0.333*2 ); else
		if ( power >= 1.333 ) addPart( parts.engines.I4:0x0000000Ar, "2.2L I4 engine", actcolor, optical, (power-1.333)/0.333*2 ); else
		if ( power >= 1 ) addPart( parts.engines.I4:0x00000009r, "2.0L I4 engine", actcolor, optical, (power-1)/0.333*2 ); else
		if ( power >= 0.5 ) addPart( parts.engines.I4:0x00000008r, "1.8L I4 engine", actcolor, optical, (1-power)/0.5*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_01.axis:0x000000D8r, "hood", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( optical-1 >= 0.66667 ) addPart( cars.cat_01.axis:0x000000DAr, "hood 3", actcolor, optical, power ); else
			if ( optical-1 >= 0.33333 ) addPart( cars.cat_01.axis:0x000000D9r, "hood 2", actcolor, optical, power ); else
			addPart( cars.cat_01.axis:0x000000D8r, "hood", actcolor, optical, power );
		}

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		addPart( cars.cat_01.Axis:0x0000FFB4r, "steering wheel" );
	}
	
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(1,0,1.0); //2WD all becomes FWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}